## Jean-Marc Gemperle 2012
## All credits to:
## IR stuff : http://www.eventghost.org/ 
## PlugWise stuff : python-plugwise hadara  https://bitbucket.org/hadara/python-plugwise/overview


from serial.serialutil import SerialException
from plugwise import *
import plugwise.util
import datetime
import threading
import socket
import SocketServer
from cStringIO import StringIO
from tokenize import generate_tokens
from serial import *
from threading import Event, Thread
import serial, time
import socket
import SocketServer
import getopt, sys, os
import struct, math
import binascii
import asyncore
import socket
import zlib


DEFAULT_SERIAL_PORT = "COM3"

from ctypes import (
    c_int, c_uint, c_ulong, byref, c_ubyte, c_char_p, c_void_p, POINTER,
    WINFUNCTYPE, Structure, GetLastError, create_string_buffer, WinDLL,
    string_at,
)
######################################################################################
class Text:
    uuInfo = "USB-UIRT Info"
    uuProtocol = "Protocol Version: "
    uuFirmVersion = "Firmware Version: "
    uuFirmDate = "Firmware Date: "
    redIndicator = "Red Indicator LED Operation"
    blinkRx = "Blink when Receiving IR"
    blinkTx = "Blink when Transmitting IR"
    notFound = "<not found>"
    irReception = "IR Reception"
    legacyCodes = "Generate 'legacy' UIRT2-compatible events"
    stopCodes = "Pass short repeat codes as enduring events"

    class TransmitIR:
        name = "Transmit IR"
        description = "Transmits an IR code via the USB-UIRT hardware."
        irCode = "IR Code:"
        learnButton = "Learn an IR Code..."
        repeatCount = "Repeat Count:"
        infinite = "Infinite"
        wait1 = "Wait:"
        wait2 = "ms of IR inactivity before transmission"
        zone = "Zone:"
        zoneChoices = (
            "All",
            "Ext. Jack R-Pin",
            "Ext. Jack L-Pin",
            "Internal Emitter",
        )
        class LearnDialog:
            title = "Learn IR Code"
            frequency = "Frequency"
            signalQuality = "Signal"
            progress = "Learn Progress"
            acceptBurstButton = "Accept Burst"
            forceRaw = "Force RAW-Mode learning"
            helpText = \
                "1. Aim remote directly at USB-UIRT\n"\
                "approximately 6 inches from USB-UIRT face.\n\n"\
                "2. PRESS and HOLD the desired button on\n"\
                "your remote until learning is complete..."


INVALID_HANDLE_VALUE = -1
UINT32 = c_uint

class UUINFO(Structure):
    _fields_ = (
        ('fwVersion',   c_uint),
        ('protVersion', c_uint),
        ('fwDateDay',   c_ubyte),
        ('fwDateMonth', c_ubyte),
        ('fwDateYear',  c_ubyte),
    )
PUUINFO = POINTER(UUINFO)

UUIRTDRV_ERR_NO_DEVICE = 0x20000001
UUIRTDRV_ERR_NO_RESP = 0x20000002
UUIRTDRV_ERR_NO_DLL = 0x20000003
UUIRTDRV_ERR_VERSION = 0x20000004

UUIRTDRV_CFG_LEDRX = 0x0001
UUIRTDRV_CFG_LEDTX = 0x0002
UUIRTDRV_CFG_LEGACYRX = 0x0004

UUIRTDRV_IRFMT_UUIRT = 0x0000
UUIRTDRV_IRFMT_PRONTO = 0x0010

UUIRTDRV_IRFMT_LEARN_FORCERAW = 0x0100
UUIRTDRV_IRFMT_LEARN_FORCESTRUC    = 0x0200
UUIRTDRV_IRFMT_LEARN_FORCEFREQ = 0x0400
UUIRTDRV_IRFMT_LEARN_FREQDETECT    = 0x0800


UUCALLBACKPROC = WINFUNCTYPE(c_int, POINTER(c_ubyte), c_ulong, c_ulong)
LEARNCALLBACKPROC = WINFUNCTYPE(c_int, c_uint, c_uint, c_ulong, c_void_p)


class USB_UIRT():
    text = Text
    info =""

    def __init__(self):
      
        self.dll = None
        self.enabled = False
        self.__start__(True,True,False,False)
        #TransmitIR()

    def getDLL(self):
        return self.dll
    
    def getDriver(self):
        return self.hDrvHandle
        
    def __close__(self):
        self.irDecoder.Close()


    
    def __start__(
        self,
        ledRX=True,
        ledTX=True,
        legacyRX=False,
        repeatStopCodes=False,
    ):
        self.args = (ledRX, ledTX, legacyRX, repeatStopCodes)
        self.codeFormat = UUIRTDRV_IRFMT_PRONTO
        try:
            dll = WinDLL('uuirtdrv')
        except:
            raise self.Exceptions.DriverNotFound
        puDrvVersion = c_uint(0)
        if not dll.UUIRTGetDrvInfo(byref(puDrvVersion)):
            raise self.Exception("Unable to retrieve uuirtdrv version!")
        if puDrvVersion.value != 0x0100:
            raise self.Exception("Invalid uuirtdrv version!")

        
        hDrvHandle = dll.UUIRTOpenEx("USB-UIRT", 0, 0, 0)
        if hDrvHandle == INVALID_HANDLE_VALUE:
            err = GetLastError()
            if err == UUIRTDRV_ERR_NO_DLL:
                raise self.Exceptions.DriverNotFound
            elif err == UUIRTDRV_ERR_NO_DEVICE:
                raise self.Exceptions.DeviceNotFound
            elif err == UUIRTDRV_ERR_NO_RESP:
                raise self.Exceptions.DeviceInitFailed
            else:
                raise self.Exceptions.DeviceInitFailed
        self.hDrvHandle = hDrvHandle

        """JMG 
        puuInfo = UUINFO()
        if not dll.UUIRTGetUUIRTInfo(hDrvHandle, byref(puuInfo)):
            raise self.Exceptions.DeviceInitFailed
        self.firmwareVersion = "%d.%d" % (
            puuInfo.fwVersion >> 8,
            puuInfo.fwVersion & 0xFF
        )
        self.protocolVersion = "%d.%d" % (
            puuInfo.protVersion >> 8,
            puuInfo.protVersion & 0xFF
        )
        self.firmwareDate = datetime.date(
            puuInfo.fwDateYear+2000,
            puuInfo.fwDateMonth,
            puuInfo.fwDateDay
        )
       
 """    
        self.dll = dll
        self.receiveProc = UUCALLBACKPROC(self.ReceiveCallback)
        res = dll.UUIRTSetRawReceiveCallback(
            self.hDrvHandle,
            self.receiveProc,
            0
        )
       
        if not res:
            self.dll = None
            raise self.Exception("Error calling UUIRTSetRawReceiveCallback")

        self.SetConfig(ledRX, ledTX, legacyRX, repeatStopCodes)
        
        self.enabled = True

        
    def Transmit(self, code='', repeatCount=4, inactivityWaitTime=0):
        #if not self.plugin.dll:
        #    raise self.Exceptions.DeviceNotReady
        
        if len(code) > 5:
            start = 0
            if code[0] == "Z":
                start = 2
            if code[start+3] == "R":
                codeFormat = UUIRTDRV_IRFMT_UUIRT
            elif code[start+4] == " ":
                codeFormat = UUIRTDRV_IRFMT_PRONTO
            else:
                codeFormat = UUIRTDRV_IRFMT_LEARN_FORCESTRUC
        else:
            repeatCount = 0
            codeFormat = UUIRTDRV_IRFMT_PRONTO
            code = ""
        
        codeFormat = UUIRTDRV_IRFMT_PRONTO
        if not self.dll.UUIRTTransmitIR(
            self.hDrvHandle,    # hHandle
            c_char_p(code),     # IRCode
            codeFormat,         # codeFormat
            repeatCount,        # repeatCount
            inactivityWaitTime, # inactivityWaitTime
            0,                  # hEvent
            0,                  # reserved1
            0                   # reserved2
        ):
            raise self.Exceptions.DeviceNotReady


    def __stop__(self):
        self.enabled = False
        dll = self.dll
        if dll:
            if not dll.UUIRTClose(self.hDrvHandle):
                raise self.Exception("Error calling UUIRTClose")

            # fix for USB-UIRT driver bug, See OnComputerSuspend for details.
            self.hDrvHandle = dll.UUIRTOpenEx(self.deviceStr, 0, 0, 0)
            # without the UUIRTSetUUIRTConfig call, the driver seems to need
            # much more time to close.
            self.SetConfig(*self.args)
            dll.UUIRTSetReceiveCallback(self.hDrvHandle, None, 0)
            dll.UUIRTClose(self.hDrvHandle)
            self.dll = None


    def OnComputerSuspend(self, suspendType):
        # The USB-UIRT driver seems to have a bug, that prevents the wake-up
        # from standby feature to work, if UUIRTSetRawReceiveCallback was used.
        # To workaround the problem, we re-open the device with
        # UUIRTSetReceiveCallback just before the system goes into standby and
        # later do the reverse once the system comes back from standby.
        dll = self.dll
        if dll is None:
            return
        dll.UUIRTClose(self.hDrvHandle)
        self.hDrvHandle = dll.UUIRTOpenEx(self.deviceStr, 0, 0, 0)
        dll.UUIRTSetReceiveCallback(self.hDrvHandle, None, 0)


    def OnComputerResume(self, suspendType):
        dll = self.dll
        if dll is None:
            return
        dll.UUIRTClose(self.hDrvHandle)
        self.hDrvHandle = dll.UUIRTOpenEx(self.deviceStr, 0, 0, 0)
        dll.UUIRTSetRawReceiveCallback(self.hDrvHandle, self.receiveProc, 0)
        self.SetConfig(*self.args)


    def OnDeviceRemoved(self, event):
        if event.payload[0].split("#")[1] == 'Vid_0403&Pid_f850':
            if self.dll:
                if not self.dll.UUIRTClose(self.hDrvHandle):
                    raise self.Exception("Error calling UUIRTClose")
                self.dll = None



    def OnDeviceAttached(self, event):
        if event.payload[0].split("#")[1] == 'Vid_0403&Pid_f850':
            if self.enabled:
                self.__start__(*self.args)


    def SetConfig(self, ledRX, ledTX, legacyRX, repeatStopCodes=False):
        value = 0
        if ledRX:
            value |= UUIRTDRV_CFG_LEDRX
        if ledTX:
            value |= UUIRTDRV_CFG_LEDTX
        if legacyRX:
            value |= UUIRTDRV_CFG_LEGACYRX
        if repeatStopCodes:
            value |= 16
        if not self.dll.UUIRTSetUUIRTConfig(self.hDrvHandle, UINT32(value)):
            self.dll = None
            raise self.Exception("Error calling UUIRTSetUUIRTConfig")


    def ReceiveCallback(self, buf, length, userdata):
        # TODO: find a more efficient way to find the terminator
        data = []
        for i in range(2, 1024):
            value = buf[i]
            data.append(value)
            if value == 255:
                break
        return 0


    def Configure(
        self,
        ledRx=True,
        ledTx=True,
        legacyRx=None,
        repeatStopCodes=False,
    ):
        text = self.text
        if self.dll:
            protocolVersion = self.protocolVersion
            firmwareVersion = self.firmwareVersion
            firmwareDate = self.firmwareDate.strftime("%x")
        else:
            protocolVersion = text.notFound
            firmwareVersion = text.notFound
            firmwareDate = text.notFound

 
        ledRxCheckBox = True
        ledTxCheckBox = True
        legacyRxCheckBox = True
        stopCodesRxCheckBox = True


class IRLearn():

    progressCtrl=''
    def __init__(self, dll, hDrvHandle):
        self.dll = dll
        self.hDrvHandle = hDrvHandle
        self.code = None
        self.codeFormat = UUIRTDRV_IRFMT_PRONTO
        self.sigQualityCtrl = 0
        carrierFreqCtrl =0
        self.carrierFreqCtrl = carrierFreqCtrl
        forceRawCtrl = False
        self.forceRawCtrl = forceRawCtrl
        self.StartLearnIR()


    def SetRawMode(self, flag=True):
        if flag:
            self.codeFormat = UUIRTDRV_IRFMT_LEARN_FORCERAW
        else:
            self.codeFormat = UUIRTDRV_IRFMT_PRONTO


    def StartLearnIR(self):
        self.learnThreadAbortEvent = threading.Event()
        self.bAbortLearn = c_int(0)
        self.learnThread = threading.Thread(target=self.LearnThread)
        self.learnThread.start()
   


    def AbortLearnThread(self):
        self.bAbortLearn.value = True


    def AbortLearnThreadWait(self):
        self.bAbortLearn.value = True
        self.learnThreadAbortEvent.wait(10)


    def AcceptBurst(self):
        self.bAbortLearn.value = -1


    def LearnThread(self):
        learnBuffer = create_string_buffer('\000' * 2048)
        self.dll.UUIRTLearnIR(
            self.hDrvHandle,                       # hHandle
            self.codeFormat,                       # codeFormat
            learnBuffer,                           # IRCode buffer
            LEARNCALLBACKPROC(self.LearnCallback), # progressProc
            0x5a5a5a5a,                            # userData
            byref(self.bAbortLearn),               # *pAbort
            0,                                     # param1
            0,                                     # reserved0
            0                                      # reserved1
        )
        if self.bAbortLearn.value != 1:
            self.OnLearnSuccess(learnBuffer.value)
        self.learnThreadAbortEvent.set()


    def LearnCallback(self, progress, sigQuality, carrierFreq, userData):
        #if progress > 0:
        #self.burstButton.Enable(True)
        self.progressCtrl=progress
        self.sigQualityCtrl=sigQuality
        self.carrierFreqCtrl="%d.%03d kHz" % (carrierFreq / 1000, carrierFreq % 1000)
        return 0


    def OnLearnSuccess(self, code):
        global learnedCode
        lock = threading.Lock()
        lock.acquire()
        try:
            self.code = code
            learnedCode=code
        finally:
            lock.release()
            
        self.OnClose()


    def OnRawBox(self, event):
        self.AbortLearnThreadWait()
        self.SetRawMode(self.forceRawCtrl.GetValue())
        self.burstButton.Enable(False)
        self.progressCtrl.SetValue(0)
        self.sigQualityCtrl.SetValue(0)
        self.StartLearnIR()


    def OnAcceptBurst(self, event):
        self.AcceptBurst()


    def OnClose(self):
        self.AbortLearnThread()



    def OnCancel(self, event):
        self.Close()
    
    def timeoute(self):
        self.close();


######################################################################################
def SetPlugWisePowerState(mac, state):
    try:
        
        mac=mac.encode('ascii','ignore')
        c = Circle(mac, gdevice)
        
        if state=='2':
            if (c.get_info()['relay_state']) ==0:
                c.switch_on()
                return '1'
            else:
                c.switch_off()
                return '0'
    
        if state=='0':
            c.switch_off()
            return '0'
        
        if state=='1':
            c.switch_on()
            return '1'
        
    except (TimeoutException, SerialException) as reason:
        return "FAIL: %s" % (reason,)    


def GetPlugWisePowerState(mac):
    try:
        mac=mac.encode('ascii','ignore')
        c = Circle(mac, gdevice)
        
        if (c.get_info()['relay_state']) ==0:
            return '0'
        else:
            return '1'
     
    except (TimeoutException, SerialException) as reason:
        return "FAIL: %s" % (reason,)    


def GetPlugWiseWattage(mac):
    try:
        mac=mac.encode('ascii','ignore')
        c = Circle(mac, gdevice)
        
        return "%.2f" % (c.get_power_usage(),)
   
    except (TimeoutException, SerialException) as reason:
        return "FAIL: %s" % (reason,)    

def USBUIRTSEnd(ir):
    global usb

    #usb=USB_UIRT()
    try:
        usb.Transmit(ir)
    except:
        pass

def USBUIRTSLearn():
    global learn
    print "LEARN"
    global learnedCode
    #usb=USB_UIRT()
    lock = threading.Lock()
    learnedCode=''
    endtime = time.time() + 20
    learn=IRLearn(usb.getDLL(),usb.getDriver())
    
    lock.acquire()
    try:
        while learnedCode =='': 
            if time.time() > endtime:
                learnedCode="TIMEOUT! : Try again or cancel..."
                learn.AbortLearnThread()
                print "TIMEOUT"
                break
    finally:
        lock.release()
    return learnedCode
    

####################################################################  
#--------------------------MAIN ENTRY processing client request on PLUGWIZE or IR -------------------------------

class MyTCPHandler(SocketServer.BaseRequestHandler):

    def handle(self):
        global srvpassword
        global clipassword
        data = self.request.recv(1024).strip()

        #decompress = zlib.decompressobj(-zlib.MAX_WBITS)
        #toto=zlib.decompress(  data,zlib.MAX_WBITS,2000)
        #print data
        #now = datetime.datetime.now()
        #start = now.replace(hour=2, minute=47, second=0, microsecond=0)
        #end = now.replace(hour=2, minute=49, second=0, microsecond=0)
        #if now >=start and now <=end:
        #print " the time"
        if data:
            device, macaddress, action=data.split(":")

        if device=="REMOTEGATE_PASSWORD":
            clipassword=macaddress

        if srvpassword==clipassword:

            if device=="PLUGWISE" and action == "PTG":
                SetPlugWisePowerState(macaddress,"2")
                
            if device=="PLUGWISE" and action == "WH":
                self.request.send(GetPlugWiseWattage(macaddress))
            
            if device=="PLUGWISE" and action == "00":  
                SetPlugWisePowerState(macaddress,"0")
                
            if device=="PLUGWISE" and action == "01":    
                SetPlugWisePowerState(macaddress,"1")    
                
            if device == "USB-UIRT":
                USBUIRTSEnd(macaddress) 
                
            if device == "USB-UIRT" and macaddress == "LR":   
                self.request.send(USBUIRTSLearn())
            
            if macaddress == "CANCEL_LEARNING":
                try:
                    print "cancelled"
                    learn.AbortLearnThread()
                except:
                    pass
      
                                      
####################################################################

srvpassword=""
clipassword=""

if __name__ == '__main__':
    global recycling
    
    gdevice=DEFAULT_SERIAL_PORT
    gdevice = Stick(gdevice)


    global usb
    global bIn
    bIn=False
    usb=USB_UIRT()
    recycling=False
    global learnedCode
        
  
    HOST, PORT = "192.168.178.88", 9998
    server = SocketServer.TCPServer((HOST, PORT), MyTCPHandler)
  
    try:  
        print "RemoteGateServer" 
        print "==========="
        print "Jean-Marc Gemperle 2013, adapted from:"  
        print "    USB-UIRT from EventGhost: http://www.eventghost.org/" 
        print "    PlugWise from adara python-plugwise: https://bitbucket.org/hadara/python-plugwise/overview"     

        if len(sys.argv) <2:
            print "Must pass an password as argument."
            sys.exit(1)

        srvpassword=str(sys.argv[1])
        clipassword=""
        server.serve_forever()
    
    except KeyboardInterrupt:
        runIT=False
        server.server_close()
        print "bye"    

 

